// VERSION: Scilab: 5.4.1 
// OS: windows 7 
// CAPTION: PROGRAM TO GENERATE COMMON DISCRETE TIME SIGNALS

//UNIT IMPULSE SIGNAL
clc;
clear all;
close;
N=5; //SET LIMIT
t1=-5:5;
x1=[zeros(1,N),ones(1,1),zeros(1,N)];
subplot(2,4,1);
plot2d3(t1,x1)
xlabel('time');
ylabel('Amplitude');
title('Unit impulse signal');


//UNIT STEP SIGNAL
t2=-5:5;
x2=[zeros(1,N),ones(1,N+1)];
subplot(2,4,2);
plot2d3(t2,x2)
xlabel('time');
ylabel('Amplitude');
title('Unit step signal');

//EXPONENTIAL SIGNAL
t3=0:1:20;
x3=exp(-t3);
subplot(2,3,3);
plot2d3(t3,x3);
xlabel('time');
ylabel('Amplitude');
title('Exponential signal');



//UNIT RAMP SIGNAL
t4=0:20;
x4=t4;
subplot(2,3,4);
plot2d3(t4,x4);
xlabel('time');
ylabel('Amplitude');
title('Unit ramp signal');

//SINUSOIDAL SIGNAL
t5=0:0.04:1;
x5=sin(2*%pi*t5);
subplot(2,3,5);
plot2d3(t5,x5);
title('Sinusoidal Signal')
xlabel('time');
ylabel('Amplitude');

//RANDOM SIGNAL
t6=-10:1:20;
x6=rand(1,31);
subplot(2,3,6);
plot2d3(t6,x6);
xlabel('time');
ylabel('Amplitude');
title('Random signal');
